/**
 * Controls the settings page in the message drawer.
 *
 * @module     core_message/message_drawer_view_settings
 * @copyright  2018 Ryan Wyllie <ryan@moodle.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define("core_message/message_drawer_view_settings",["jquery","core/notification","core/str","core/pubsub","core/templates","core_message/message_repository","core/custom_interaction_events","core_message/message_drawer_events"],(function($,Notification,Str,PubSub,Templates,Repository,CustomEvents,MessageDrawerEvents){var SELECTORS_CHECKBOX='input[type="checkbox"]',SELECTORS_SETTINGS='[data-region="settings"]',SELECTORS_PRIVACY_PREFERENCE='[data-preference="blocknoncontacts"] input[type="radio"]',SELECTORS_NOTIFICATIONS_PREFERENCE='[data-preference="notifications"] input[type="checkbox"]',SELECTORS_ENTER_TO_SEND_PREFERENCE='[data-preference="entertosend"] input[type="checkbox"]',SELECTORS_NOTIFICATION_PREFERENCES_CONTAINER='[data-region="notification-preference-container"]',SELECTORS_CONTENT_CONTAINER='[data-region="content-container"]',SELECTORS_PLACEHOLDER_CONTAINER='[data-region="placeholder-container"]',TEMPLATES_NOTIFICATION_PREFERENCES="core_message/message_drawer_view_settings_body_content_notification_preferences",savePreferences=function(loggedInUserId,preferences){return Repository.savePreferences(loggedInUserId,preferences).then((function(){PubSub.publish(MessageDrawerEvents.PREFERENCES_UPDATED,preferences)})).catch(Notification.exception)},init=function(body,loggedInUserId){Repository.getUserMessagePreferences(loggedInUserId).then((function(response){!function(body,value){body.find(SELECTORS_PRIVACY_PREFERENCE).each((function(index,input){(input=$(input)).val()==value?input.prop("checked",!0):input.prop("checked",!1)}))}(body,response.blocknoncontacts),function(body,value){var checkbox=body.find(SELECTORS_ENTER_TO_SEND_PREFERENCE);value?checkbox.prop("checked",!0):checkbox.prop("checked",!1)}(body,response.entertosend);var notificationProcessors=[];response.preferences.components.length&&response.preferences.components.forEach((function(component){if(component.notifications.length&&component.notifications.filter((function(notification){return"message_provider_moodle_instantmessage"==notification.preferencekey})).length){var configuration=component.notifications[0];notificationProcessors=configuration.processors.map((function(processor){var checked=processor.enabled;return{displayname:processor.displayname,name:processor.name,checked:checked,locked:processor.locked,lockedmessage:processor.lockedmessage||null}}))}}));var container=body.find(SELECTORS_NOTIFICATION_PREFERENCES_CONTAINER);return!notificationProcessors.length||(container.removeClass("hidden"),Templates.render(TEMPLATES_NOTIFICATION_PREFERENCES,{processors:notificationProcessors}).then((function(html){return container.append(html),html})))})).then((function(){body.find(SELECTORS_CONTENT_CONTAINER).removeClass("hidden"),body.find(SELECTORS_PLACEHOLDER_CONTAINER).addClass("hidden"),function(body,loggedInUserId){var settingsContainer=body.find(SELECTORS_SETTINGS);CustomEvents.define(settingsContainer,[CustomEvents.events.activate]),settingsContainer.on(CustomEvents.events.activate,SELECTORS_NOTIFICATIONS_PREFERENCE,(function(e){var checkboxes=$(e.target).closest(SELECTORS_NOTIFICATION_PREFERENCES_CONTAINER).find(SELECTORS_CHECKBOX);if(checkboxes.length){var values=checkboxes.toArray().reduce((function(carry,checkbox){return(checkbox=$(checkbox)).prop("checked")&&carry.push(checkbox.attr("data-name")),carry}),[]),newValue=values.length?values.join(","):"none";savePreferences(loggedInUserId,[{type:"message_provider_moodle_instantmessage_enabled",value:newValue}])}})),settingsContainer.on("change",SELECTORS_PRIVACY_PREFERENCE,(function(e){var newValue=$(e.target).val();savePreferences(loggedInUserId,[{type:"message_blocknoncontacts",value:newValue}])})),settingsContainer.on(CustomEvents.events.activate,SELECTORS_ENTER_TO_SEND_PREFERENCE,(function(e){var newValue=$(e.target).prop("checked");savePreferences(loggedInUserId,[{type:"message_entertosend",value:newValue}])}))}(body,loggedInUserId)})).catch(Notification.exception)};return{show:function(namespace,header,body,footer,loggedInUserId){return body.attr("data-init")||(init(body,loggedInUserId),body.attr("data-init",!0)),$.Deferred().resolve().promise()},description:function(){return Str.get_string("messagedrawerviewsettings","core_message")}}}));

//# sourceMappingURL=message_drawer_view_settings.min.js.map